class MůjKontext:
     
    def __enter__(self):
        print('\nSpouštím kontext…')
        return 'Ahoj!'
     
    def __exit__(self, typ, hodnota, traceback):
        print('Opouštím kontext…')
        if typ is None:
            print('…bez chyby.')
        else:
            print('…s chybou {} .'.format(hodnota))
        return True
 
 
with MůjKontext() as f:
    print('1. kontext bez chyby')
    print(f'--> {f}')
 
with MůjKontext() as f:
    print('2. kontext s chybou')
    print(f'--> {f}')
    raise TypeError('CHYBA')
